/**
* \file: app_iface_abstract.c
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: authorization level daemon
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#include <string.h>

#include "app_iface/app_iface.h"

#include "model/challenge.h"
#include "model/daemon_model.h"

#include "control/ald.h"
#include "control/daemon_fsm.h"

#include "util/logger.h"

//contains the implementation of the functionality provided by the daemon to the application interface binding

security_level_t app_iface_get_security_level(void)
{
	return daemon_model_get_active_level();
}

void app_iface_request_daemon_exit_due_to_errors(error_code_t error)
{
	ald_request_daemon_exit_due_to_errors(error);
}

void app_iface_request_level_change(const challenge_response_t *response,
		level_change_request_callback_t callback)
{
    // 1 additional byte to ensure we have a null terminated string(just for logging purposes)
	char tmp_string[RESPONSE_SERIAL_NUMBER_SIZE+1]={0};

	strncpy(tmp_string, response->serial_number, RESPONSE_SERIAL_NUMBER_SIZE);

	logger_log_info("Received a response. (serial number: %s, targeted level: %d)",
			tmp_string, (int)response->targeted_level);
	logger_log_errmem("ALD - Received a response. (serial number: %s, targeted level: %d)",
			tmp_string, (int)response->targeted_level);
	daemon_fsm_signal_level_change_request(response, callback);
}

void app_iface_request_lock_device(level_change_request_callback_t callback)
{
	logger_log_info("Got a request to lock the device.");
	logger_log_errmem("ALD - Got a request to lock the device.");
	daemon_fsm_signal_lock_device_request(callback);
}

const challenge_t *app_iface_create_new_challenge(const char *arg_ecu_id)
{
    // 1 additional byte to ensure we have a null terminated string (just for logging purposes)
	char ecu_id[CHALLENGE_ECU_ID_SIZE+1]={0};

	strncpy(ecu_id,arg_ecu_id,CHALLENGE_ECU_ID_SIZE);
	logger_log_info("Challenge requested with ECU_ID: %s",ecu_id);

	challenge_create_new(ecu_id);
	ald_activate_challenge_timeout();

	logger_log_errmem("ALD - Challenge requested with ECU_ID: %s",ecu_id);

	return challenge_get_current();
}

daemon_level_state_t app_iface_get_daemon_level_state(void)
{
	return daemon_model_get_level_state();
}

void app_iface_set_ready(void)
{
	daemon_model_app_iface_set_ready();
}
